/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package graphicrectangle;
import java.awt.Color;

/**
 *
 * @author vana
 */
public class Rectangle {
    private Point origin;
    private int width;
    private int height;
    private Color color;
     
    public Rectangle() {
        origin = new Point(0, 0);
        width = 0;
        height = 0;
        color = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
    }
    
    public Rectangle(int initX, int initY, int initWidth, int initHeight) {
        origin = new Point(initX, initY);
        width = initWidth;
        height = initHeight;
        color = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
    }
    
    public Rectangle(Point origin, int width, int height) {
        this.width = width;
        this.height = height;
        this.origin = new Point(origin);
        color = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
    }
    
    @Override 
    public String toString () {
        return "origin: " + origin + ", W: " + width + " H: " + height;
    }
    public int getArea (String message) {
        System.out.println(message);
        return getArea();
    }
    
    public int getArea() {
        return width * height;
    }
    
    public void move (int dx, int dy) {
        origin.setX(origin.getX()+dx);
        origin.setY(origin.getY()+dy);
    }
    
    public int getX () {
        return origin.getX();
    }
    
    public int getY () {
        return origin.getY();
    }
    
    public int getWidth () {
        return width;
    }
    
    public int getHeight () {
        return height;
    }
    
    public Color getColor() {
        return color;
    }
}
