/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package graphicrectangle;

import javax.swing.*;
import java.awt.GridLayout;
import java.awt.BorderLayout;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

/**
 *
 * @author vana
 */
public class MainWindow {

    public static final int WIN_WIDTH = 600;
    public static final int WIN_HEIGHT = 400;
        
    public static void main(String[] args) {
        
        final JFrame window = new JFrame("Rectangles everywhere!");
        window.setSize(WIN_WIDTH, WIN_HEIGHT);
        //window.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        window.setLayout(new BorderLayout());
        
        // right panel, will contain the drawing area
        final DrawingPanel drawingPanel = new DrawingPanel();

        // left panel, will contain input boxes and buttons
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new GridLayout(4, 3));
        
        
        final JTextField enterX = new JTextField("0", 3);
        enterX.setHorizontalAlignment(JTextField.CENTER);
        final JTextField enterY = new JTextField("0", 3);
        enterY.setHorizontalAlignment(JTextField.CENTER);
        final JTextField enterWidth = new JTextField("0", 3);
        enterWidth.setHorizontalAlignment(JTextField.CENTER);
        final JTextField enterHeight = new JTextField("0", 3);
        enterHeight.setHorizontalAlignment(JTextField.CENTER);
        
        JButton drawButton = new JButton("Draw");
        drawButton.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent ae){
                int x = 0, y = 0, width = 10, height = 10;
                try {
                    x = Integer.parseInt(enterX.getText());
                } catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(window, "x not an integer - using default value 0");
                }
                try {
                    y = Integer.parseInt(enterY.getText());
                } catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(window, "y not an integer - using default value 0");
                }
                try {
                    width = Integer.parseInt(enterWidth.getText());
                } catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(window, "width not an unsigned integer - using default value 10");
                }
                try {
                    height = Integer.parseInt(enterHeight.getText());
                } catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(window, "height not an unsigned integer - using default value 10");
                }
                drawingPanel.setRectangle( new Rectangle(x, y, width, height));
                drawingPanel.repaint();
            }
        } );
        
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent ae){
                drawingPanel.clear();
                drawingPanel.repaint();
            }
        });
        
        JButton exitButton = new JButton("Exit");
        exitButton.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent ae){
                System.exit(0);
            }
        });
        
        inputPanel.add(new JLabel("x:", JLabel.RIGHT));
        inputPanel.add(enterX);
        inputPanel.add(drawButton);
        inputPanel.add(new JLabel("y:", JLabel.RIGHT));
        inputPanel.add(enterY);
        inputPanel.add(clearButton);
        inputPanel.add(new JLabel("width:", JLabel.RIGHT));
        inputPanel.add(enterWidth);
        inputPanel.add(exitButton);
        inputPanel.add(new JLabel("height:", JLabel.RIGHT));
        inputPanel.add(enterHeight);

        window.add(inputPanel, BorderLayout.WEST);   
        
        window.add(drawingPanel, BorderLayout.CENTER);
        
        window.setVisible(true);
    }  
}
