/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package graphicrectangle;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import java.util.ArrayList;
import java.awt.Color;
import java.awt.BasicStroke;
/**
 *
 * @author vana
 */
public class DrawingPanel extends JPanel {
    
    private ArrayList<Rectangle> shapes;
    private boolean blank;

    public DrawingPanel() {
        super();
        blank = true;
        shapes = new ArrayList<>();    
        
    }
    public void setRectangle(Rectangle rectangle) {
        shapes.add(rectangle);
        blank = false;
    }
    
    public void clear () {
        blank = true;
    }
    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.setBackground(java.awt.Color.YELLOW);
        g2.setStroke(new BasicStroke(3));
        if (blank) {           
            g2.drawRect(0, 0, getWidth(), getHeight());            
            shapes.clear();
            
        }
        else  {
            Color current = g2.getColor();
            for (Rectangle rectangle : shapes) {
                g2.setColor(rectangle.getColor());
                g2.drawRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
            }
            g2.setColor(current);
            
        }
    }
    
}
