/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
import java.util.*;
import java.io.*;
/**
 *
 * @author ece
 */
public class TelephoneList {
    
    private Set<TelephoneNumber> set;
    
    public Set<TelephoneNumber> getSet() { return set; }
    
    public TelephoneList(File file) {
      set = new HashSet<TelephoneNumber>();
      
      TelephoneNumber number;
      try(Scanner sc = new Scanner(file)) {
        while(sc.hasNext()) {          
          String word = sc.next();
          if(word.charAt(word.length()-1) == ':') {
              word = word.substring(0,word.length()-1);
              number = new TelephoneNumber(word);              
              while(sc.hasNext()) {
                  word = sc.next();
                  if(!word.equals("$"))
                      number.addNumber(word);
                  else
                      break;
              }
              set.add(number);
          }
        }
      }
      catch(FileNotFoundException ex) {
          System.err.println("File not found!");
      }
    }
    
    public boolean add(TelephoneNumber number) {
      return set.add(number);
    }
    
    public boolean remove(String name) {
      Iterator<TelephoneNumber> it = set.iterator();
      while(it.hasNext()) {
          TelephoneNumber tNumber = it.next();
          if(tNumber.getName().equals(name)) {
              it.remove();
              return true;
          }
      }
      return false;
    }
    
    public String toString(){
      String str = "";
      for(TelephoneNumber number: set)
        str += number + System.getProperty("line.separator");
      return str;
    }
    
    public TelephoneNumber searchByName(String name) {
      Iterator<TelephoneNumber> it = set.iterator();
      while(it.hasNext()) {
          TelephoneNumber tNumber = it.next();
          if(tNumber.getName().equals(name))
              return tNumber;
      }
      return null;
    }    
    
    public TelephoneNumber searchByNumber(String number) {
      Iterator<TelephoneNumber> it = set.iterator();
      while(it.hasNext()) {
          TelephoneNumber tNumber = it.next();
          Set<String> numbers = tNumber.getNumbers();
          Iterator<String> itStr = numbers.iterator();
          while(it.hasNext()) {
            if( it.next().equals(number) )
                return tNumber;
          }
      }
      return null;
    }
    
    public static void main(String [] args) {
        String filename = "numbers.txt";
        TelephoneList myList = new TelephoneList(new File(filename));
        Scanner sc = new Scanner(System.in);
        String name;
        TelephoneNumber number;
        while(true) {
          System.out.println("\t\tMENU");
          System.out.println("\t\tAdd (a)");
          System.out.println("\t\tSearch (?)");
          System.out.println("\t\tDelete (d)");
          System.out.println("\t\tPrint (p)");
          System.out.println("\t\tSave (s)\n");
          System.out.print("Your choice? ");
          String option = sc.next();
          switch(option) {
              case "a":
                  System.out.print("Enter name: ");
                  name = sc.next();
                  number = new TelephoneNumber(name);
                  if(!myList.add(number)) {
                    System.out.println("User already exists!");
                    continue;
                  }                    
                  System.out.print("Enter number or # to exit: ");
                  String num="";
                  while( !(num = sc.next()).equals("#") ) {
                      System.err.println("Number read: "+num);
                      number.addNumber(num);
                  }
                break;
              case "?":
                  System.out.print("Enter name: ");
                  name = sc.next();
                  number = myList.searchByName(name);
                  if(number!=null)
                      System.out.println(number);
                  else
                      System.out.println("Nothing found!");
                break;
              case "d":
                  System.out.print("Enter name: ");
                  name = sc.next();
                  if( myList.remove(name) )                   
                      System.out.println("Removed contact: "+name);
                  else
                      System.out.println("Contact not found!");
                break;
              case "s":
                  try(PrintWriter writer = new PrintWriter(new File(filename))) {
                      writer.print(myList);                      
                  }
                  catch(FileNotFoundException ex) {
                    System.err.println("Filename was not found for writing!");
                  }
                break;
              case "p":
                  System.out.println(myList);
                break;
              default:
          }
        }
    }
    
}
