/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

import java.util.*;

/**
 *
 * @author ece
 */
public class Student implements Comparable<Student> {
    
    private String name;
    private double average;
    private List<Course> courses;
    
    public Student (String name, double average) {
      this.name = name;
      this.average = average;
      courses = new ArrayList<Course>();
    }
    
    public Student(String name) {
      this(name, 0);      
    }
    
    public String getName() { return name; }    
    public double getAverage() {
      double sum = 0.0;
      for(Course course: courses)
          sum = sum + course.getGrade();
      average = sum/courses.size();
      return average;
    }
    public void setName(String name ) { this.name = name; }
    public void setAverage(double average) { this.average = average; }
    
    public List<Course> getCourses() { return courses; }
    
    /* 
     * Return -1, if subjectName does not exist.
     */
    public int getCourseGrade(String courseName) {
      if(courseName == null)
          return -1;
      /*for(Course course : courses) {
          if(course.getName().equals(courseName))
              return course.getGrade();
      }*/
      Iterator<Course> it = courses.iterator();
      while(it.hasNext()) {
        Course course = it.next();
        if(course.getName().equals(courseName))
              return course.getGrade();
      }
      return -1;
    }
    
    public void addCourse(String courseName, int grade) {
      Course newCourse = new Course(courseName, grade);
      courses.add(newCourse);
    }
    
    public boolean removeCourse(String courseName) {
      if(courseName == null)
        return false;
      Iterator<Course> it = courses.iterator();
      while(it.hasNext()) {
        Course course = it.next();
        if(course.getName().equals(courseName)) {
          //courses.remove(course);
          it.remove(); 
          return true;
        }
      }
      return false;
    }
    
    public String toString() {
      String str = "NAME: "+name+"\n";
      str += "AVG: "+getAverage()+"\n";
      str += "COURSES: "+ courses.size()+"\n";
      for(Course course: courses) 
          str += course.toString() +"\n";
      str += "----------------\n";
      return str;
    }

    public int compareTo(Student other) {
        return name.compareTo(other.name);
        //return (int)(getAverage() - other.getAverage());
    }
    
    
}
