/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Student
implements Comparable<Student> {
    private String name;
    private double average;
    private List<Course> courses;

    public Student(String name, double average) {
        this.name = name;
        this.average = average;
        this.courses = new ArrayList<Course>();
    }

    public Student(String name) {
        this(name, 0.0);
    }

    public String getName() {
        return this.name;
    }

    public double getAverage() {
        double sum = 0.0;
        for (Course course : this.courses) {
            sum += (double)course.getGrade();
        }
        this.average = sum / (double)this.courses.size();
        return this.average;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAverage(double average) {
        this.average = average;
    }

    public List<Course> getCourses() {
        return this.courses;
    }

    public int getCourseGrade(String courseName) {
        if (courseName == null) {
            return -1;
        }
        for (Course course : this.courses) {
            if (!course.getName().equals(courseName)) continue;
            return course.getGrade();
        }
        return -1;
    }

    public void addCourse(String courseName, int grade) {
        Course newCourse = new Course(courseName, grade);
        this.courses.add(newCourse);
    }

    public boolean removeCourse(String courseName) {
        if (courseName == null) {
            return false;
        }
        Iterator<Course> it = this.courses.iterator();
        while (it.hasNext()) {
            Course course = it.next();
            if (!course.getName().equals(courseName)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public String toString() {
        String str = "NAME: " + this.name + "\n";
        str = str + "AVG: " + this.getAverage() + "\n";
        str = str + "COURSES: " + this.courses.size() + "\n";
        for (Course course : this.courses) {
            str = str + course.toString() + "\n";
        }
        str = str + "----------------\n";
        return str;
    }

    @Override
    public int compareTo(Student other) {
        return this.name.compareTo(other.name);
    }
}

