/*
 * PersistentCounter.java
 *
 * Created on November 20, 2006, 10:04 PM
 */

import java.io.*;
import java.net.*;

import javax.servlet.*;
import javax.servlet.http.*;

/**
 *
 * @author IkoIko
 * @version
 */
public class PersistentCounter extends HttpServlet {
    
    
    private int count;
    private String filename;
    
    public void init(ServletConfig config)
    throws ServletException{
        
        super.init(config);
        ServletContext sctx = config.getServletContext();
        String path = sctx.getRealPath("/");
        filename = path+"PersistentVisitCounter.dat";
        
        try{ 
            
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            String scount = br.readLine();
            count = Integer.parseInt(scount);
            return;
        }
        catch (FileNotFoundException ignored){}
        catch (IOException ignored){}
        catch (NumberFormatException ignored){}
        count = 0;
        
    }
  
    
    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        
         response.setContentType("text/html; charset=ISO-8859-7");
        int localCount;
        synchronized(this){
            localCount = count++;
        }
        
        PrintWriter out = response.getWriter();
        out.println("This servlet has been visited by " + localCount);
        out.println(filename);
        
    }
    
    
    public void destroy(){
        
        if (filename!=null){
            
            try{
                
                FileWriter fw = new FileWriter(filename);
                String scount = Integer.toString(count);
                fw.write(scount, 0, scount.length());
                fw.close();
                return;
                
            }
            catch (IOException e){
                
                log("File exception during writing visit counter", e);
                
            }
            
        }
        
    }
}
