/*
 * NumGuessServlet.java
 *
 * Created on 9 ? 2005, 10:35 ?
 */

import java.io.*;

import javax.servlet.*;
import javax.servlet.http.*;

/**
 *
 * @author george
 * @version
 */
public class NumGuessServlet extends HttpServlet {
      
    /** Initializes the servlet.
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }
    
    /** Destroys the servlet.
     */
    public void destroy() {
    }
    
    /** Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head>");
        out.println("<title>Lucky Guess Result</title>");
        out.println("</head>");
        out.println("<body>");
      
        String sguess = request.getParameter("guess");
        int guess = 0;
        
        try {
            guess = Integer.parseInt(sguess);
        }
        catch (NumberFormatException e) {
            out.println("Enter a number please");
            out.println("<a href=\"NumGuessForm.html\">Click here</a>");
            return;
        }
        HttpSession session = request.getSession();
        Integer oNumber = (Integer) session.getAttribute("number");
        int number;
        if (oNumber==null) {
            number = Math.abs(new java.util.Random().nextInt() % 100) + 1;
            session.setAttribute("number", new Integer(number));
        }
        else {
            number = oNumber.intValue();
        }
        if (guess == number) {
            out.println("You got it!<br>");
            session.removeAttribute("number");
            
        }
        else if (guess < number) {
            out.println("Try again but HIGHER this time<br>");
            
        }
        else {
            out.println("Try again but LOWER this time<br>");
            
        } 
        out.println("<a href=\"NumGuessForm.html\">Back to the form</a>");   
        out.println("</body>");
        out.println("</html>");
        
        out.close();
    }
    
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
    
}
