//package simple;

import java.io.*;
import java.net.*;

import javax.servlet.*;
import javax.servlet.http.*;

/**
 *
 * @author george
 * @version
 */
public class Accumulator extends HttpServlet {
    
    private int data;
    private String filename;
    
    /** Initializes the servlet.
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext ctx = config.getServletContext();
        String path = ctx.getRealPath("/");
        filename = path+"data.txt";
        try {
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            String sdata = br.readLine();
            data = Integer.parseInt(sdata);
            return;
        }
        catch (FileNotFoundException ignored) {}
        catch (IOException ignored) {}
        catch (NumberFormatException ignored) {}              
       data = 0;
       log("Accumulator: Init method was called");
    }
    
    /** Destroys the servlet.
     */
    public void destroy() {
        log("Accumulator: destroy method was called");
        try {
            FileWriter fw = new FileWriter(filename);
            fw.write(Integer.toString(data));
            fw.close();
        }
        catch (IOException e) {
            log("Accumulator: Exception occured when saving data during destroy", e);
        }
    }
    
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        String svalue = request.getParameter("value");
        int value = 0;
        try {
            value = Integer.parseInt(svalue);
        }
        catch (NumberFormatException e) {
            log("Accumulator: Number Format Exception", e);
            out.println("<font color=\"red\">Not a valid number</font>");
            return;
        }
        data += value;
        out.println("<html>");
        out.println("<head>");
        out.println("<title>Accumulator</title>");
        out.println("</head>");
        out.println("<body>");
        out.println("<h3>Result so far is: "+data+"</h3>") ;
        out.println("</body>");
        out.println("</html>");
        
        out.close();
    }
}
