// API - file api.h for libpathviz.so //

// *** Function Prototypes *** //

// General Functions //

extern void init_globals();

// Floorplan //

void get_floorplan_dimensions(double *, double *, double *, double *, double *, double *);

// Placement Related //

// Components //

extern unsigned long get_total_components(int);
extern unsigned long get_total_placed_components(int);
extern int get_component_iterator(unsigned long *, int *);
extern int next_component_iterator(unsigned long *, int *);
extern void get_component_name(unsigned long, int, char **);
extern int get_component_is_placed(unsigned long, int);
extern int get_component_location(unsigned long, int, double *, double *);
extern int get_component_dimensions(unsigned long, int, double *, double *);
extern int get_component_CCs(unsigned long, int, unsigned long **, int **, unsigned long *);
extern int get_component_output_gatepins(unsigned long, int, unsigned long **, int **, unsigned long *);
extern int get_gatepin_slack(unsigned long, int, char, double *, double *);

// Top-Level IOs //

extern int get_toplevelio_iterator(unsigned long *);
extern int next_toplevelio_iterator(unsigned long *);
extern void get_toplevelio_name(unsigned long, char **);
extern int get_toplevelio_location(unsigned long, double *, double *);
extern int get_toplevelio_CCs(unsigned long , unsigned long **, int **, unsigned long *);

// Initialise CCs for both Components and Top-Level IOs //

int init_components_toplevelios_CCs();

// TCL Commands Interface //

int load_lef(ClientData, Tcl_Interp *, int, Tcl_Obj *const*);
int load_lib(ClientData, Tcl_Interp *, int, Tcl_Obj *const*);
int load_verilog(ClientData, Tcl_Interp *, int, Tcl_Obj *const*);
int load_def(ClientData, Tcl_Interp *, int, Tcl_Obj *const*);
int io_place(ClientData, Tcl_Interp *, int, Tcl_Obj *const*);

// *** Externals *** //

extern int initialise_floorplan(ClientData clientdata, Tcl_Interp *interp, int objc, Tcl_Obj *const* objv);
extern int set_component_location(ClientData clientdata, Tcl_Interp *interp, int objc, Tcl_Obj *const* objv);
extern int set_port_location(ClientData clientdata, Tcl_Interp *interp, int objc, Tcl_Obj *const* objv);
extern int create_clock(ClientData clientdata, Tcl_Interp *interp, int objc, Tcl_Obj *const* objv);
extern int set_input_delay(ClientData clientdata, Tcl_Interp *interp, int objc, Tcl_Obj *const* objv);
extern int set_output_delay(ClientData clientdata, Tcl_Interp *interp, int objc, Tcl_Obj *const* objv);
extern int all_inputs(ClientData clientdata, Tcl_Interp *interp, int objc, Tcl_Obj *const* objv);
extern int all_outputs(ClientData clientdata, Tcl_Interp *interp, int objc, Tcl_Obj *const* objv);
extern int get_ports(ClientData clientdata, Tcl_Interp *interp, int objc, Tcl_Obj *const* objv);
extern int compute_delay(ClientData clientdata, Tcl_Interp *interp, int objc, Tcl_Obj *const* objv);
extern int compute_slack(ClientData clientdata, Tcl_Interp *interp, int objc, Tcl_Obj *const* objv);
extern int report_timing(ClientData clientdata, Tcl_Interp *interp, int objc, Tcl_Obj *const* objv);

extern int currentflowstep;
extern int lefloaded;
extern int libloaded;
extern int defloaded[];
extern int verilogloaded[];
