/*
 * Decompiled with CFR 0.152.
 */
package ce325.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

public class FileBrowser
extends JPanel {
    JTextField text;
    JButton nextBtn;
    JButton backBtn;
    JButton upBtn;
    JButton homeBtn;
    JList<File> list;
    ArrayList<File> history;
    boolean showHiddenFiles = true;

    public FileBrowser() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "North");
        this.backBtn = new JButton(new ImageIcon("images/back.png"));
        this.backBtn.setActionCommand("back");
        BackBtnListener backBtnListener = new BackBtnListener();
        this.backBtn.addActionListener(backBtnListener);
        this.backBtn.setMargin(new Insets(0, 0, 0, 0));
        this.upBtn = new JButton(new ImageIcon("images/up.png"));
        this.upBtn.setActionCommand("up");
        UpBtnListener upBtnListener = new UpBtnListener();
        this.upBtn.addActionListener(upBtnListener);
        this.upBtn.setMargin(new Insets(0, 0, 0, 0));
        this.homeBtn = new JButton(new ImageIcon("images/home.png"));
        this.homeBtn.addActionListener(new HomeBtnListener());
        this.homeBtn.setMargin(new Insets(0, 0, 0, 0));
        this.nextBtn = new JButton(new ImageIcon("images/next.png"));
        this.nextBtn.setActionCommand("next");
        NextBtnListener nextBtnListener = new NextBtnListener();
        this.nextBtn.addActionListener(nextBtnListener);
        this.nextBtn.setMargin(new Insets(0, 0, 0, 0));
        this.history = new ArrayList();
        this.history.add(new File(System.getProperty("user.home")));
        this.text = new JTextField(System.getProperty("user.home"), 40);
        this.text.addActionListener(nextBtnListener);
        this.text.setFont(new Font("Default", 1, 18));
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(this.backBtn);
        jPanel.add(this.upBtn);
        jPanel.add(this.homeBtn);
        jPanel.add(this.text);
        jPanel.add(this.nextBtn);
        this.list = new JList<File>(this.listFiles(System.getProperty("user.home")));
        this.list.setVisibleRowCount(20);
        this.list.addMouseListener(new ListMouseListener());
        MyCellRenderer myCellRenderer = new MyCellRenderer();
        this.list.setCellRenderer(myCellRenderer);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        this.add((Component)jScrollPane, "South");
    }

    JMenuBar createMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenu jMenu2 = new JMenu("Options");
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        JMenuItem jMenuItem = new JMenuItem("New..");
        jMenu.add(jMenuItem);
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Show hidden files/folders", this.showHiddenFiles);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileBrowser.this.showHiddenFiles = jCheckBoxMenuItem.getState();
                FileBrowser.this.updateListFromCurrentDir();
            }
        });
        jMenu2.add(jCheckBoxMenuItem);
        return jMenuBar;
    }

    File[] listFiles(String string) {
        File file = new File(string);
        return this.listFiles(file);
    }

    File[] listFiles(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        File[] fileArray = file.listFiles();
        if (!this.showHiddenFiles) {
            ArrayList<File> arrayList = new ArrayList<File>();
            for (File file2 : fileArray) {
                if (file2 == null || file2.isHidden()) continue;
                arrayList.add(file2);
            }
            fileArray = new File[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                fileArray[i] = (File)arrayList.get(i);
            }
        }
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                if (file.isDirectory() && file2.isDirectory()) {
                    return file.compareTo(file2);
                }
                if (!file.isDirectory() && file2.isDirectory()) {
                    return 1;
                }
                if (file.isDirectory() && !file2.isDirectory()) {
                    return -1;
                }
                if (!file.isDirectory() && !file2.isDirectory()) {
                    return file.compareTo(file2);
                }
                return 0;
            }
        });
        return fileArray;
    }

    void updateListFromText(String string) {
        File[] fileArray;
        File file = new File(string);
        File file2 = this.history.get(this.history.size() - 1);
        if (file.exists() && file.isDirectory() && !file.getAbsolutePath().equals(file2.getAbsolutePath())) {
            this.history.add(file);
        }
        if ((fileArray = this.listFiles(file)) == null) {
            JOptionPane.showMessageDialog(this, "The selected path: \"" + string + "\" is invalid!", "Invalid Path", 0);
            return;
        }
        this.list.setListData((File[])fileArray);
    }

    void updateListFromCurrentDir() {
        File file = this.history.get(this.history.size() - 1);
        File[] fileArray = this.listFiles(file);
        this.list.setListData((File[])fileArray);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("CE325 File Browser");
        FileBrowser fileBrowser = new FileBrowser();
        jFrame.setJMenuBar(fileBrowser.createMenu());
        jFrame.setContentPane(fileBrowser);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
        jFrame.pack();
    }

    class MyCellRenderer
    implements ListCellRenderer<Object> {
        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            File file = (File)object;
            ImageIcon imageIcon = file.isDirectory() ? new ImageIcon("images/dir.png") : new ImageIcon("images/file.png");
            Image image = imageIcon.getImage().getScaledInstance(25, 25, 1);
            imageIcon = new ImageIcon(image);
            JLabel jLabel = new JLabel(file.getName(), imageIcon, 2);
            jLabel.setOpaque(true);
            return jLabel;
        }
    }

    class ListMouseListener
    extends MouseAdapter {
        ListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                int n = FileBrowser.this.list.locationToIndex(mouseEvent.getPoint());
                File file = FileBrowser.this.list.getModel().getElementAt(n);
                if (file.isDirectory()) {
                    File[] fileArray = FileBrowser.this.listFiles(file);
                    FileBrowser.this.text.setText(file.getAbsolutePath());
                    FileBrowser.this.list.setListData((File[])fileArray);
                    FileBrowser.this.history.add(file);
                } else {
                    try {
                        Desktop.getDesktop().open(file);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(FileBrowser.this, "Unable to open file: \"" + file.getName() + "\"!", "Error opening file", 0);
                        return;
                    }
                }
            }
        }
    }

    class HomeBtnListener
    implements ActionListener {
        HomeBtnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = System.getProperty("user.home");
            File[] fileArray = FileBrowser.this.listFiles(string);
            FileBrowser.this.history.add(new File(string));
            FileBrowser.this.text.setText(string);
            FileBrowser.this.list.setListData((File[])fileArray);
        }
    }

    class UpBtnListener
    implements ActionListener {
        UpBtnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = FileBrowser.this.history.get(FileBrowser.this.history.size() - 1);
            File file2 = file.getParentFile();
            if (file2 == null || !file2.exists()) {
                return;
            }
            FileBrowser.this.history.add(file2);
            FileBrowser.this.text.setText(file2.getAbsolutePath());
            File[] fileArray = FileBrowser.this.listFiles(file2);
            FileBrowser.this.list.setListData((File[])fileArray);
        }
    }

    class BackBtnListener
    implements ActionListener {
        BackBtnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (FileBrowser.this.history.size() < 2) {
                return;
            }
            FileBrowser.this.history.remove(FileBrowser.this.history.size() - 1);
            File file = FileBrowser.this.history.get(FileBrowser.this.history.size() - 1);
            File[] fileArray = FileBrowser.this.listFiles(file);
            FileBrowser.this.text.setText(file.getAbsolutePath());
            FileBrowser.this.list.setListData((File[])fileArray);
        }
    }

    class NextBtnListener
    implements ActionListener {
        NextBtnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileBrowser.this.updateListFromText(FileBrowser.this.text.getText());
        }
    }
}

