public class Rectangle {
    
  private int width;
  private int height;
  private Point origin;
    
  private int id;

  private static int numberOfRectangles = 0;

  public Rectangle(int width, int height, Point origin) {
    this.width = width;
    this.height = height;
    this.origin = origin;
    this.id = ++numberOfRectangles;
  }
  
  public Rectangle(int width, int height, int xPos, int yPos) {
    this(width, height, new Point(xPos,yPos));
  }

  public Rectangle(int width, int height) {
    this(width, height, 0, 0);
  }

  @Override
  public String toString() {
    return "id " + id + ": " + origin + " w: " + width + " h: " + height;
  }

  public int getID() {
    return id;
  }

  public static int getNumberOfRectangles() {
    return numberOfRectangles;
  }
    
  public void setWidth(int newWidth ) {
    width = newWidth;
  }
  
  public int getWidth() {
    return width;
  }
    
  public void setHeight(int newHeight ) {
    height = newHeight;
  }
  
  public int getHeight() {
    return height;
  }
    
  public void setOrigin(Point newOrigin) {
    origin = newOrigin;
  }
  
  public Point getOrigin() {
    return origin;
  }
  
  public int getArea() {
       return width * height;
  }
   
  // Move rectangle origin by dx,dy
  public void move(int dx, int dy) {
    origin.setX( origin.getX() + dx );
    origin.setY( origin.getY() + dy );
  }
}
