
import java.util.Objects;





public class Rectangle extends BasicRectangle {
    
  Point origin;
    
  public Rectangle(int initWidth, int initHeight, Point initOrigin) {
    super(initWidth, initHeight);
    origin = initOrigin;
  }
  
  public Rectangle(int initWidth, int initHeight, int originX, int originY) {
    super(initWidth, initHeight);
    origin = new Point(originX,originY);
  }
    
  public void setOrigin(Point newOrigin) {
    origin = newOrigin;
  }
  
  public Point getOrigin() {
    return origin;
  }
   
  // Move rectangle origin by dx,dy
  public void moveOrigin(int dx, int dy) {
    origin.setX( origin.getX() + dx );
    origin.setY( origin.getY() + dy );
  }
  
  public String toString() {
    String str = origin.toString() + " ";
    str = str + toString();
    return str;
  }
  
  @Override
  public boolean equals(Object o) {
    if(o == null)
      return false;
    if(o instanceof Rectangle) {
      Rectangle r = (Rectangle)o;
      if(r.width == width && r.height == height && r.origin.equals(origin))
        return true;
    }
    return false;
  }

  @Override
  public int hashCode() {
    int hash = 7;
    hash += 13 * width;
    hash += 17 * height;
    hash = 31 * hash + Objects.hashCode(this.origin);
    return hash;
  }

  

}