

public class Point {
  int x;   // x coordinate
  int y;   // y coordinate
  
  public Point(int xPos, int yPos) {
    x = xPos;
    y = yPos;
  }
  
  public int getX() {
    return x;
  }
  
  public void setX(int xPos) {
    x = xPos;
  }
  
  public int getY() {
    return y;
  }
  
  public void setY(int yPos) {
    y = yPos;
  }
  
  public String toString() {
    return "("+x+","+y+")";
  }
  
  @Override
  public boolean equals(Object o) {
    if(o == null)
      return false;
    if(o instanceof Point) {
      Point p = (Point)o;
      if(p.x == x && p.y == y)
        return true;
    }
    return false;
  }

  @Override
  public int hashCode() {
    int hash = 3;
    hash = 19 * hash + this.x;
    hash = 17 * hash + this.y;
    return hash;
  }
}