#!/usr/local/ActivePerl-5.8/bin/perl

use XML::Simple;
use Data::Dumper;

$datafile = "/Users/stroulia/world_writable/stroulia.xml";

print "----- run 1 -----\n";
my $xs = new XML::Simple(keeproot => 1,
			 searchpath => ".");
my $ref = $xs->XMLin($datafile);
my $xml = $xs->XMLout($ref);

print "\nHash dump without 'forcearray => 1':\n";
print Dumper($ref);
print "\nXML output without 'forcearray => 1':\n";
print $xml;

print "----- run 2 -----\n";
my $xs = new XML::Simple(keeproot => 1,
			 searchpath => ".",
			 forcearray => 1);
my $ref = $xs->XMLin($datafile);

my $xml = $xs->XMLout($ref);
print "\nHash dump with 'forcearray => 1':\n";
print Dumper($ref);
print "\nXML output with 'forcearray => 1':\n";
print $xml;
exit;
