#!/usr/local/ActivePerl-5.8/bin/perl

use CGI ':standard';
use CGI::Pretty qw( :html3 );
use XML::Simple;
use Data::Dumper;


print header(),
  start_html('Saving form data as XML: a simple example'),
  start_form("GET","http://localhost/~stroulia/cgi-bin/xml_perl_css_js/xml_form.cgi"),
  p,
  "Last name: ", textfield('last_name'),
  p,
  "First name: ", textfield('first_name'),
  p,
  "Your color preferences: ",
  checkbox_group(-name=>'colors',
		 -values=>['blue','green','red','purple','yellow','chartreuse']),
  p,
  submit,
  end_form,
  hr;

if (param()) {
  
  my $datastring = $ENV{"QUERY_STRING"};
  $datastring =~s/%0D%0A/\n/g;

  my @formHash;
  
  @nameValuePairs = split(/&/, $datastring);
  foreach $pair (@nameValuePairs) {
  
    ($name, $value) = split(/=/, $pair);    
    $name =~tr/+/ /;                    
    $name =~s/%([\da-fA-F]{2})/pack("C",hex($1))/eg;
    $value =~tr/+/ /;                               
    $value =~s/%([\da-fA-F]{2})/pack("C",hex($1))/eg;
    
    if(exists $formHash{$name}) {
      $formHash{$name} = $formHash{$name}.";".$value;
    }
    else {
      $formHash{$name} = $value;
    }
  }

  $datafile = "/Users/stroulia/world_writable/".$formHash{"last_name"}.".xml";
  open(FORMFILE, ">>$datafile") or &errorPage;
  print FORMFILE "<?xml version=\"1.0\"?>\n<form>\n";
  print FORMFILE "<last>$formHash{'last_name'}</last>\n";
  print FORMFILE "<first>$formHash{'first_name'}</first>\n";
  @colors = split(/;/, $formHash{'colors'});
  foreach $color (@colors) {
  print FORMFILE "<color>$color</color>\n"; }
  print FORMFILE "</form>";
  close(ORDERFILE);
  
}
print end_html;

print "\n";
