#!/usr/local/ActivePerl-5.8/bin/perl

use strict;
use CGI qw/:standard *div/;
use CGI::Carp qw(fatalsToBrowser);
use CGI::Pretty qw( :html3 );

print 
  header,
  start_html(-title=>'XML, CSS, JS', 
	     -script=>{
		       -language => 'javascript',
		       -src => 'http://localhost/~stroulia/designers-demo.js' }, 
	     -style=>{'src'=>"http://localhost/~stroulia/designers.css"}),
  
  h1('A Simple Example of a perl GCI script, delivering HTML, XML, JS and CSS content.'),
  
  start_form(-method=>"GET", 
	     -action=>"http://localhost/~stroulia/cgi-bin/xml_perl_css_js/demo3.cgi");

print
  start_div({-ID=>"designersArea"});

print
  p, 
  "What's your favorite designer? ", textfield('designer_name'),
  p,
  button(-name=>"submit_form", 
	 -value=>"Click here to see them!", 
	 -onclick=>"javascript:loadDesigners()",
	 -ID=>"showDesignersButton");
print 
  end_div({-ID=>"designersArea"}),
  p,
  submit,
  p,
  end_form,
  hr;

if (param()) {
  my $designer_name = param('designer_name');
  print 
    "Your favorite designer is",
      em(escapeHTML($designer_name)),
	hr;
}

print end_html;
