#!/usr/local/ActivePerl-5.8/bin/perl

# This script illustrates how to use JavaScript to validate fill-out forms.
use CGI qw(:standard);
use CGI::Pretty qw( :html3 );

# Here's the javascript code that we include in the document.
$JSCRIPT=<<EOF;

function simple_test () {
    var ol = document.createElement("OL");
    var li = document.createElement("LI");
    var cdata = document.createTextNode("test");
    li.appendChild(cdata);
    ol.appendChild(li);

    var parent = document.getElementById("root");
    parent.appendChild(ol);
}

function loadDesigners () {
    // Use the standard DOM Level 2 technique, if it is supported
	if (document.implementation && document.implementation.createDocument) {
	    // Create a new Document object
		xmldoc = document.implementation.createDocument("", "doc", null);
	    // Specify what should happen when it finishes loading
		xmldoc.onload = showDesignersList;
	    // And tell it what URL to load
		xmldoc.load('http://localhost/~stroulia/designers.xml');
    }
}

function showDesignersList () {
    blurbs = xmldoc.getElementsByTagName('blurb');
    ol = document.createElement("OL");

    for (var i=0; i < blurbs.length; i++)
    {
	li = document.createElement("li");

	//1. Retrieve the blurb element from the collection
	//2. Get the designer element within the blurb (assumes only one designer per blurb)
	//3. In DOM the text in designer is a text node object child of blurb. 
	//   The link title is the value of this text node

	blurb = blurbs[i];
	designer = blurb.getElementsByTagName('designer').item(0);       
	link_title = designer.firstChild.nodeValue;
	cdata = document.createTextNode(link_title);

	li.appendChild(cdata);
	ol.appendChild(li);
    }
  parent = document.getElementById("designersArea");
  parent.appendChild(ol);
}
EOF
    
print header;

print
  start_html(-title=>'XML, CSS, JS', -script=>$JSCRIPT, -style=>{'src'=>"http://localhost/~stroulia/designers.css"}),
  
  h1('A Simple Example of a perl GCI script, delivering HTML, XML, JS and CSS content.'),
  
  start_form(-method=>"GET", 
	     -action=>"http://localhost/~stroulia/cgi-bin/xml_perl_css_js/demo.cgi", 
	     -ID=>"designersArea"),
  
  p, 
  "What's your favorite designer? ", textfield('designer_name'),
  p,
  button(-name=>"submit_form", 
	 -value=>"Click here to see them!", 
	 -onclick=>"javascript:loadDesigners()",
	 -ID=>"showDesignersButton"),
  p,
  submit,
  p,
  end_form,
  hr;

if (param()) {
  my $designer_name = param('designer_name');
  print 
    "Your favorite designer is",
      em(escapeHTML($designer_name)),
	hr;
}

print end_html;
