#! /usr/bin/perl
print "Content-type: text/html\n\n";

if ($ENV{"REQUEST_METHOD"} eq "POST") {
  read(STDIN, $datastring, $ENV{"CONTENT_LENGTH"});		
}
elsif (exists $ENV{"REQUEST_METHOD"}) {		# data from GET transaction (or HEAD or other)
  $datastring = $ENV{"QUERY_STRING"};
}
else {
  print "Offline execution detected\n";
  print "Please enter some data.\n";
  $datastring = <>;
  chomp $datastring;
  print "== data accepted == HTML output follows ==\n\n";
}

###decode######################################################
$datastring =~s/%0D%0A/\n/g;                    			#step to deal with line
									#breaks in text areas
@nameValuePairs = split(/&/, $datastring);				#step 1
foreach $pair (@nameValuePairs) {
  ($name, $value) = split(/=/, $pair);					#step 2
  
  $name =~tr/+/ /;                                 			#step 3
  $name =~s/%([\da-fA-F]{2})/pack("C",hex($1))/eg; 			#step 3
  $value =~tr/+/ /;                                			#step 3
  $value =~s/%([\da-fA-F]{2})/pack("C",hex($1))/eg;			#step 3
  if(exists $formHash{$name}) {					#improved step 4,
    $formHash{$name} = $formHash{$name}.";".$value;			#now handles multiple
  }									#select menus
  else {
    $formHash{$name} = $value;
  }   	
}
###done decoding###############################################

$stateDir = "/Users/stroulia/Sites/world_writable/Statedir/"; 

### the data source #######################################
@quiz_question = (
  "How many hairs are there on Homer Simpson's head?",
  "What planet is Luke Skywalker from?",
  "What is the last digit if you multiply 3 by itself a million times?"
);
@quiz_choices = (
  "0;1;2;3;4",
  "Alderaan;Bespin;Corellia;Dantooine;Tatooine",
  "1;3;5;7;9"
);
@quiz_answer = (
  "2",
  "Tatooine",
  "1"
);
### end data source #######################################


if($formHash{"request"} eq "begin_quiz") {
 	&begin_quiz;
}
elsif($formHash{"request"} eq "grade_question") {
	&grade_question;
}
else {
	&welcome_page;
}

#################################################################
sub welcome_page {
 print <<PAGE;
 <html><head><title>Trivia Quiz</title></head>
  <body>
   <h2>Welcome to the Trivia Quiz</h2>
   You will be given a series of questions.
    <form action="$ENV{'SCRIPT_NAME'}" method="GET">
     <input type="hidden" name="request" value="begin_quiz">
     <input type="submit" value="Begin Quiz">
    </form>
 </body>
</html>
PAGE
}


#################################################################
sub begin_quiz {
 my $sessionID = &generate_random_string(32);
 %stateHash = ("qnumber"=>1, "correct"=>0);
 &write_state($stateDir, $sessionID, %stateHash);

 print <<TOP;
 <html><head><title>Trivia Quiz</title></head><body>
   Here is your first question.<br/>
TOP

 &print_question($sessionID, 1);

 print <<BOTTOM;
 </body></html>
BOTTOM
}


#################################################################
sub print_question {
  my ($sessionID, $qnumber) = @_;
  my $index = $qnumber - 1;
  my @choices = split(/;/, $quiz_choices[$index]);
  
  print<<QUESTION;
  <form action = "$ENV{'SCRIPT_NAME'}" method="GET"><br />
  $qnumber. $quiz_question[$index]
  <br/> 
QUESTION

  foreach $answer (@choices) {
     print '<input type="radio" name="answer" value="', "$answer\" />$answer";
  }
  print<<FORM;
   <br/>
   <input type="hidden" name="id" value="$sessionID"/>
   <input type="hidden" name="qnumber" value="$qnumber"/>
   <input type="hidden" name="request" value="grade_question"/>
   <input type="submit" value="Submit answer"/>
   </form>
FORM
}



#################################################################
sub grade_question {
  my $sessionID = $formHash{"id"};
  %stateHash= &read_state($stateDir, $sessionID);

  if ($stateHash{"qnumber"} > scalar @quiz_question) { 
    $sentence = "Quiz is over.";
  }
  elsif($formHash{"qnumber"} < $stateHash{"qnumber"}) { # don't cheat!
    $sentence = "You have already answered that question.";
  }
  else { 
    if($formHash{"answer"} eq $quiz_answer[$stateHash{"qnumber"}-1]) {
      $stateHash{"correct"}++;
      $sentence = "Your answer of $formHash{answer} is CORRECT.<br/>\n";
    }
    else {
      $sentence =  "Sorry, your answer of $formHash{answer} is INCORRECT.<br/>\n";
    }
    $stateHash{"qnumber"}++; 
    &write_state($stateDir, $sessionID, %stateHash);
  }

  print<<TOP;
	<html><head><title>Trivia Quiz</title></head><body>
  $sentence
TOP
  if($stateHash{"qnumber"} > scalar @quiz_question) {
    print "Your final score is $stateHash{correct} correct out of ",
          scalar @quiz_question, ".\n",
          "Thank you for playing.<br/>\n",
          "<a href=\"$ENV{'SCRIPT_NAME'}?request=begin_quiz\">To play again</a>";
  }
  else {
    print "Your score so far is $stateHash{correct} correct out of ", 
          $stateHash{qnumber}-1, ".\n",
          "Here is your next question.\n"; 
    &print_question($sessionID, $stateHash{"qnumber"});
  }
  print<<BOTTOM;
  </body></html>
BOTTOM
}	




#################################################################
#################################################################
# end app logic functions
# begin toolkit functions
#################################################################
#################################################################



#################################################################
sub write_state {
 my ($dir, $fileroot, %states) = @_;
 my $filename = "$fileroot.state";
 open(OUTFILE, ">$dir$filename") or &errorPage("Error writing to state file.");
 foreach $key (keys %states) {
 $value = &URLencode($states{$key});
 $name = &URLencode($key);
   print OUTFILE "$name=$value\n";
 }
 close(OUTFILE);
}


#################################################################
sub read_state {
 my ($dir, $fileroot) = @_;
 my $filename = "$fileroot.state";
 open(INFILE, "<$dir$filename") or &errorPage("Error reading state file.");
 my @array =<INFILE>;        
 close(INFILE);
 my %hash = ();
 foreach $line (@array) {
   chomp $line;
   my ($key, $value) = split(/=/, $line, 2);
   $key = &URLdecode($key);
   $value = &URLdecode($value);
   $hash{$key} = $value;
 }
 return %hash; 
}

################################################################
sub URLencode {
  my $string = $_[0];
  $string =~ s/([^\w])/"%".sprintf("%02x", ord($1))/eg;
  return $string;
}

################################################################
sub URLdecode {
  my $string = $_[0];
  $string =~ tr/+/ /;
  $string =~ s/%([\da-fA-F]{2})/pack("C",hex($1))/eg;
  return $string;
}

#################################################################
sub generate_random_string {
  my $length = $_[0];
  my $result = "";
  my @chars = (0..9, 'a'..'z', 'A'..'Z');
  my $which;
  for($i = 1 ; $i <= $length ; $i++) {
  	$which=int rand 62;
    $result = $result . $chars[$which];
  }
  return $result;
}

#################################################################
sub errorPage {
 my $message = $_[0];  # optional message parameter
 
 print<<ALL;
 <html><head><title>Server Error</title></head><body>
  <h2>Server Error Encountered</h2>
  $message 
  
  If the problem persists, please notify the <a href="mailto:admin\@uweb.edu">webmaster</a>.
 </body></html>
ALL
 
exit;   # terminate program since failure to open data file
}
