#! /usr/bin/perl
print "Content-type: text/html\n\n";

if ($ENV{"REQUEST_METHOD"} eq "POST") {
  read(STDIN, $datastring, $ENV{"CONTENT_LENGTH"});
}
elsif (exists $ENV{"REQUEST_METHOD"}) {		# data from GET transaction (or HEAD or other)
  $datastring = $ENV{"QUERY_STRING"};
}
else {
  print "Offline execution detected\n";
  print "Please enter some data.\n";
  $datastring = <>;
  chomp $datastring;
  print "== data accepted == HTML output follows ==\n\n";
}

# decode the input datastring into a hash table
$datastring =~s/%0D%0A/\n/g;                    			#step to deal with line
									#breaks in text areas
@nameValuePairs = split(/&/, $datastring);				#step 1
foreach $pair (@nameValuePairs) {
  ($name, $value) = split(/=/, $pair);					#step 2
  
  $name =~tr/+/ /;                                 		        #step 3
  $name =~s/%([\da-fA-F]{2})/pack("C",hex($1))/eg; 		        #step 3
  $value =~tr/+/ /;                                		        #step 3
  $value =~s/%([\da-fA-F]{2})/pack("C",hex($1))/eg;		        #step 3
  
  if(exists $formHash{$name}) {					#improved step 4,
    $formHash{$name} = $formHash{$name}.";".$value;		        #now handles multiple
  }                                                                     #select menus
  else {
    $formHash{$name} = $value;
  }   	
}
# done decoding

$stateDir = "/Users/stroulia/world_writable/";  # data in same directory as this program
$dataDir = "/Users/stroulia/world_writable/";  # data in same directory as this program

# the product catalog
@sizes = ("large", "medium", "small");
$default_size="medium";

%size_prices = (
  "large" => "8.00",
  "medium" => "6.00",
  "small" => "4.00"
);
%topping_prices = (
  "large" => "1.00",
  "medium" => "0.75",
  "small" => "0.50"
);
%toppings = (
  "m_pepperoni" => "Pepperoni",
  "m_sausage" => "Italian Sausage",
  "v_peppers" => "Green Bell Peppers",
  "v_mushrooms" => "Mushrooms",
  "v_onions" => "Vidallia Onions",
  "v_olives" => "Black Olives"
);
# end of catalog


### app logic #############################################
if($formHash{"request"} eq "confirm_order") {
  &confirm_order;
}
elsif($formHash{"request"} eq "print_receipt") {
  &print_receipt;
}
else {
  &print_empty_form(%formHash);
}
### end app logic #########################################



#################################################################
sub print_empty_form {

 print<<TOP;
 <html><head><title>Personalize a pizza</title></head>
  <body>
   <form action="$ENV{'SCRIPT_NAME'}" method="POST" >
   <table border="1">
    <tr><th>Select size</th><th>Select toppings</th></tr>
    <tr><td>
TOP

 foreach $size (@sizes) {
   print '<input type="radio" name="chosen_size" value="', $size, '"';

   if($size eq $default_size) {
     print ' checked="checked"';
   }

   print "/><b>$size</b><br/>Base Price: \$$size_prices{$size} <br/>",
     "Each topping: \$$topping_prices{$size}<br/>\n";
 }
 print " </td><td>\n";

 foreach $topping (sort keys %toppings) {
  print '<input type="checkbox" name="', $topping, '" value="yes"/>',
    "$toppings{$topping}<br/>\n";
 }

 $session_id = generate_random_string(12);
 #foreach $key (keys %formHash) { print "$key => $formHash($key)\n"; }

 print<<BOTTOM;
    </tr>
   </table>
   <input type="hidden" name="session_id" value="$session_id"/>
   <input type="hidden" name="request" value="confirm_order"/>
   <input type="submit" value="Confirm Order"/>
   </form>
  </body>
 </html>
BOTTOM

 write_state($stateDir, $session_id, %formHash);
 }

#################################################################
sub confirm_order {

 $session_id = $formHash{"session_id"};
 
 print <<TOP;
  <html><head><title>Calculating cost of your pizza $session_id</title></head>
   <body>
TOP

 $size =$formHash{"chosen_size"};
 $total=$size_prices{$size};


 print "You have selected a <b>$size</b> pizza with the following extra toppings:\n<ul>";

 foreach $topping (sort keys %toppings) {
  if(exists $formHash{$topping}) {
    $total = $total + $topping_prices{$size};
    print "<li><b>$toppings{$topping}</b></li>\n";
  }
 }
 print "</ul>\n";

 $total = sprintf "%.2f", $total;
 print "for a total of <b>\$$total</b>.\n";
 $formHash{"total"} = $total;


 print<<CONFIRM;
   Please give the following information to confirm order.<br/>
   <form action="$ENV{'SCRIPT_NAME'}" method="POST">
    Name: <input type="text" name="name" value="" size="20"/><br/>
    Phone: <input type="text" name="phone" value="" size="20"/><br/>
    <input type="hidden" name="session_id" value="$session_id"/>
    <input type="hidden" name="request" value="print_receipt"/>
CONFIRM

 print<<BOTTOM;
    <input type="submit" value="Confirm Order"/>
   </form>
   </body>
  </html>
BOTTOM

 write_state($stateDir, $session_id, %formHash);

}

#################################################################
sub print_receipt {

 $session_id = $formHash{"session_id"};
 write_state($stateDir, $session_id, %formHash);
 %formHash = read_state($stateDir, $session_id, %formHash);

 
 print <<TOP;
  <html><head><title>Thank you for your order</title></head>
   <body>
       Dear <b>$formHash{"name"}</b> (phone <b>$formHash{"phone"}</b>) thank you for your order of one <b>$formHash{"chosen_size"}</b> pizza, with the following extra toppings:<ul>
TOP

 foreach $topping (sort keys %toppings) {
  if(exists $formHash{$topping}) {
    print "<li><b>$toppings{$topping}</b></li>\n";
  }
 }


 print<<BOTTOM;
      </ul>
 for a total of <b>$formHash{"total"}</b>.
   </body>
  </html>
BOTTOM


 open(ORDERFILE, ">>$dataDir"."order.txt") or &errorPage;
 print ORDERFILE "name=", $formHash{"name"}, "\n";
 print ORDERFILE "phone=", $formHash{"phone"}, "\n";
 print ORDERFILE "total=", $formHash{"total"}, "\n";
 print ORDERFILE "size=", $formHash{"chosen_size"}, "\n";
 foreach $topping (sort keys %toppings) {
  if(exists $formHash{$topping}) {
    print ORDERFILE $toppings{$topping}, "\n";
  }
 }
 print ORDERFILE "---------------------------------------\n";
 close(ORDERFILE);
}

#################################################################
sub errorPage {
 my $message = $_[0];  # optional message parameter
 
 print<<ALL;
 <html><head><title>Server Error</title></head><body>
  <h2>Server Error Encountered</h2>
  $message 
  
  If the problem persists, please notify the <a href="mailto:admin\@uweb.edu">webmaster</a>.
 </body></html>
ALL
 
exit;   # terminate program since failure to open data file
}

#################################################################
sub write_state {
 my ($dir, $fileroot, %states) = @_;
 my $filename = "$fileroot.state";
 open(OUTFILE, ">>$dir$filename") or &errorPage("Error writing to state file.");
# print "$dir, $filename\n";

 foreach $key (keys %states) {
 #  print "$key=$states{$key}\n";
   print OUTFILE "$key=$states{$key}\n";
 }
 close(OUTFILE);
}

#################################################################
sub read_state {
 my ($dir, $fileroot) = @_;
 my $filename = "$fileroot.state";

 open(INFILE, "<$dir$filename") or &errorPage("Error reading state file.");
 my @array =<INFILE>;
 close(INFILE);

 my %hash = ();
 foreach $line (@array) {
		chomp $line;
   	my ($key, $value) = split(/=/, $line, 2);
   	$hash{$key} = $value;
 }
 return %hash;
}


sub generate_random_string {
  my $length = $_[0];
  my $result = "";
  my @chars = (0..9, 'a'..'z', 'A'..'Z');
  my $which;
  for($i = 1 ; $i <= $length ; $i++) {
  	$which=int rand 62;
    $result = $result . $chars[$which];
  }
  return $result;
}
