#! /usr/bin/perl
print "Content-type: text/html\n\n";

if ($ENV{"REQUEST_METHOD"} eq "POST") {
  read(STDIN, $datastring, $ENV{"CONTENT_LENGTH"});		
}
elsif (exists $ENV{"REQUEST_METHOD"}) {		# data from GET transaction (or HEAD or other)
  $datastring = $ENV{"QUERY_STRING"};
}
else {
  print "Offline execution detected\n";
  print "Please enter some data.\n";
  $datastring = <>;
  chomp $datastring;
  print "== data accepted == HTML output follows ==\n\n";
}

###decode######################################################
$datastring =~s/%0D%0A/\n/g;                    		#step to deal with line breaks in text areas
@nameValuePairs = split(/&/, $datastring);			#step 1
foreach $pair (@nameValuePairs) {
  ($name, $value) = split(/=/, $pair);				#step 2
  $name =~tr/+/ /;                                 		#step 3
  $name =~s/%([\da-fA-F]{2})/pack("C",hex($1))/eg; 		#step 3
  $value =~tr/+/ /;                                		#step 3
  $value =~s/%([\da-fA-F]{2})/pack("C",hex($1))/eg;		#step 3
  
  if(exists $formHash{$name}) {				#improved step 4,
    $formHash{$name} = $formHash{$name}.";".$value;		#now handles multiple select menus
  }
  else {
    $formHash{$name} = $value;
  }   	
}
###done decoding###############################################


$dataDir = "/Users/stroulia/world_writable/"; 			

# Ideally, a secure data directory should be above
# the public part of the directory tree.


###app logic###################################################
if($formHash{"request"} eq "add_comments") {
	&add_comments;
}
elsif($formHash{"request"} eq "view_comments") {
	&view_comments;
}
elsif($formHash{"request"} eq "logon_page") {
	&logon_page;
}
else {
	&welcome_page;
}
###end app logic################################################



#################################################################
sub welcome_page {
  print<<WHOLEPAGE;
   <html><head><title>Please enter some comments</title></head><body>
    <form action="$ENV{'SCRIPT_NAME'}" method="GET">
    Please enter comments here.<br/>
    <textarea name="comments" rows="3" cols="40"></textarea>
    <input type="submit" value="Submit comments"/>
    <input type="hidden" name="request" value="add_comments"/>
  </form>

  <a href="$ENV{'SCRIPT_NAME'}?request=logon_page">Logon to view comments</a>
 </body></html>
WHOLEPAGE
}


#################################################################
sub add_comments {
  $comments = $formHash{"comments"};
  chomp $comments;
  
  open(DATA, ">>$dataDir"."comments.txt") or &errorPage("Error saving comments.");
  print DATA $comments;
  print DATA "\n", "-" x 70, "\n"; # a line of 70 dashes to separate comments
  close(DATA);

	print<<PAGE;
	<html><head><title>Thank you</title></head><body>
 	Thank you for your comments. 
	<hr /><pre>
	$comments
	</pre><hr />
  
  <a href="$ENV{'SCRIPT_NAME'}?request=logon_page">Logon to View Comments</a>
 	</body></html>
PAGE
}


#################################################################
sub logon_page {
  $message = $_[0]; # an optional message
  print<<WHOLEPAGE;
	<html><head><title>Logon page</title></head><body>
  $message
  
  <form action="$ENV{'SCRIPT_NAME'}" method="POST">
   Please logon to view comments.<br/>
   Username:<input type="text" name="user" value="" size="20"/><br/>
   Password:<input type="password" name="pass" value="" size="20"/><br/>
   <input type="hidden" name="request" value="view_comments"/>
   <input type="submit" value="Logon"/>
  </form>
 	</body></html>
WHOLEPAGE
}

#################################################################
sub view_comments {
    my $result = &logon("$dataDir"."password.txt", $formHash{"user"}, $formHash{"pass"});
 	if($result ne "yes") {
   	&logon_page($result);
   	exit;
 	}
  open(DATA, "$dataDir"."comments.txt") or &errorPage("Error viewing comments.");
  my @guestbook = <DATA>;
  close(DATA);
  my $guestbook = join("", @guestbook);
	
print<<PAGE;
	<html><head><title>Guestbook Entries</title></head><body>
  <h2>The guestbook file:</h2>
  <pre>$guestbook</pre>
 </body></html>
PAGE
}



#################################################################
#################################################################
# end app logic functions
# begin toolkit functions
#################################################################
#################################################################




#################################################################
sub logon {
  my($file, $alleged_user, $alleged_pass) = @_;
  my($user, $pass, $line);
  
  open(PASS, $file) or &errorPage("Failure to access user/pass info.");
  while($line = <PASS>) {
    chomp $line;
    if($line ne ""){ ### precaution only ###
      ($user, $pass) = split(/:/, $line, 2);
      if(lc $alleged_user eq lc $user) {
      	 if($alleged_pass eq $pass) {
      		close(PASS);
		return "yes";
        }
    	    else {
    		close(PASS);
    		return "Invalid password.";
        }
      }
    }
  }
  close(PASS);
  return "Invalid user.";
}

#################################################################
sub errorPage {
 my $message = $_[0];  # optional message parameter
 
 print<<ALL;
 <html><head><title>Server Error</title></head><body>
  <h2>Server Error Encountered</h2>
  $message 
  
  If the problem persists, please notify the <a href="mailto:admin\@uweb.edu">webmaster</a>.
 </body></html>
ALL
 
	exit;   # terminate program since failure to open data file
}
