#! /usr/bin/perl
print "Content-type: text/html\n\n";

if ($ENV{"REQUEST_METHOD"} eq "POST") {
  read(STDIN, $datastring, $ENV{"CONTENT_LENGTH"});		
}
elsif (exists $ENV{"REQUEST_METHOD"}) {		# data from GET transaction (or HEAD or other)
  $datastring = $ENV{"QUERY_STRING"};
}
else {
  print "Offline execution detected\n";
  print "Please enter some data.\n";
  $datastring = <>;
  chomp $datastring;
  print "== data accepted == HTML output follows ==\n\n";
}

###decode######################################################
$datastring =~s/%0D%0A/\n/g;                    		#step to deal with line breaks in text areas
@nameValuePairs = split(/&/, $datastring);			#step 1
foreach $pair (@nameValuePairs) {
  ($name, $value) = split(/=/, $pair);				#step 2
  $name =~tr/+/ /;                                 		#step 3
  $name =~s/%([\da-fA-F]{2})/pack("C",hex($1))/eg; 		#step 3
  $value =~tr/+/ /;                                		#step 3
  $value =~s/%([\da-fA-F]{2})/pack("C",hex($1))/eg;		#step 3
  
  if(exists $formHash{$name}) {				#improved step 4,
    $formHash{$name} = $formHash{$name}.";".$value;		#now handles multiple select menus
  }
  else {
    $formHash{$name} = $value;
  }   	
}
###done decoding###############################################



$dataDir = "/Users/stroulia/world_writable/"; 			
$stateDir = "/Users/stroulia/world_writable/states/"; 	

$cache_limit = 300; 		# max number of files in cache
$file_life_span = 1;		# kill files older than one day

%stateHash=();
$sessionID = $formHash{"id"};

### app logic #############################################
if($formHash{"request"} eq "initial_logon") {
  &initial_logon;
}
elsif($formHash{"request"} eq "add_user") {
  &add_user;
}
else {
  &logon_page;
}
### end app logic #########################################



#################################################################
sub logon_page {
  $message = $_[0]; # an optional message
  print<<WHOLEPAGE;
	<html><head><title>Logon page</title></head><body>
 	<b>$message</b>
  
  <form action="$ENV{'SCRIPT_NAME'}" method="POST">
   Verify administration privileges.<br />
   Username:<input type="text" name="user" value="" size="20"/><br/>
   Password:<input type="password" name="pass" value="" size="20"/><br/>
   <input type="hidden" name="request" value="initial_logon"/>
   <input type="submit" value="Logon"/>
  </form>
 </body>
</html>
WHOLEPAGE
}

#################################################################
sub initial_logon { 
 	my $result = &logon("$dataDir"."adminpw.txt", $formHash{"user"}, $formHash{"pass"});
 	if($result ne "yes") {
   	&logon_page($result);
   	exit;
 	}
  $sessionID = &get_long_id($stateDir,$cache_limit,$file_life_span);
  %stateHash = ("user"=>$formHash{"user"}, "access"=>"admin");
  &write_state($stateDir, $sessionID, %stateHash);
  &add_user_page("You are now logged in as administrator.");
}

#################################################################
sub add_user_page {
 	$message = $_[0]; # takes an optional message parameter
  print<<WHOLEPAGE;
	<html><head><title>Add user form</title></head><body>
  <b>$message</b>

  <form action="$ENV{'SCRIPT_NAME'}" method="POST">
   Add a new user.<br />
   New user:<input type="text" name="newuser" size="20"/><br />
   New Password:<input type="password" name="newpass" size="20"/><br />
   Confirm Password:<input type="password" name="confirm" size="20"/><br />
  
    <input type="hidden" name="id" value="$sessionID"/>

    <input type="hidden" name="request" value="add_user"/>
   <input type="submit" value="Add new user"/>
  </form>
 </body></html>
WHOLEPAGE
}

#################################################################
sub add_user {
  %stateHash = &read_state("$stateDir", $sessionID);
 	if($stateHash{"access"} ne "admin") {
   	&logon_page("You need to first logon as administrator.");
   	exit;
 	}

	my $result = &logon_new("$dataDir"."password2.txt" , 
				$formHash{"newuser"}, 
				$formHash{"newpass"}, 
				$formHash{"confirm"});
 	if ($result eq "yes") {
 		&add_user_page("User successfully added.");
 	}
 	else {
 		&add_user_page("User not added. $result");
 	}
}



#################################################################
#################################################################
# end app logic functions
# begin toolkit functions
#################################################################
#################################################################



#################################################################
sub logon_new {
  my($file, $new_user, $new_pass , $confirm_pass) = @_;
  
  if((length($new_user)<4) || (length($new_pass)<4)) {
    return "User name and password must be least 4 characters long.";
  }
  # We could impose other restrictions here as well
  # such as no white space characters and no colons. 

  if($new_pass ne $confirm_pass) {
    return "Passwords do not match.";
  }

  my($user, $pass, $line);
  open(PASS, $file) or &errorPage("Failure to create new account.");
  while($line = <PASS>) {
    chomp $line;
    ($user, $pass) = split(/:/, $line, 2);
    if(lc $new_user eq lc $user) {
      close(PASS);
      return "User name already taken.";
    }
  }
  close(PASS);

  open(PASS, ">>$file") or &errorPage("Failure to create new account.");
#  print PASS "$new_user:$new_pass\n";

@list64 = ('.','/','a'..'z',0..9,'A'..'Z');
$salt = $list64[int rand 64].$list64[int rand 64];
$encr_pass = crypt($new_pass,$salt);
print PASS "$new_user:$encr_pass\n";

  close(PASS);
  return "yes";
}


#################################################################
sub logon {
  my($file, $alleged_user, $alleged_pass) = @_;
  my($user, $pass, $line);
  
  open(PASS, $file) or &errorPage("Failure to access user/pass info.");
  while($line = <PASS>) {
    chomp $line;
    if($line ne ""){ ### precaution only ###
      ($user, $pass) = split(/:/, $line, 2);
      if(lc $alleged_user eq lc $user) {
      	 if($alleged_pass eq $pass) {

#      	 if(crypt($alleged_pass, $pass) eq $pass) {

      	      close(PASS);
	      return "yes";
        }
    	    else {
	      close(PASS);
    	      return "Invalid password.";
        }
      }
    }
  }
  close(PASS);
  return "Invalid user.";
}

#################################################################
sub write_state {
 my ($dir, $fileroot, %states) = @_;
 my $filename = "$fileroot.state";
 open(OUTFILE, ">$dir$filename") or &errorPage("Error writing to state file.");
 foreach $key (keys %states) {
 $value = &URLencode($states{$key});
 $name = &URLencode($key);
   print OUTFILE "$name=$value\n";
 }
 close(OUTFILE);
}


#################################################################
sub read_state {
 my ($dir, $fileroot) = @_;
 my $filename = "$fileroot.state";
 open(INFILE, "<$dir$filename") or &errorPage("Error reading state file.");
 my @array =<INFILE>;        
 close(INFILE);
 my %hash = ();
 foreach $line (@array) {
   chomp $line;
   my ($key, $value) = split(/=/, $line, 2);
   $key = &URLdecode($key);
   $value = &URLdecode($value);
   $hash{$key} = $value;
 }
 return %hash; 
}

################################################################
sub URLencode {
  my $string = $_[0];
  $string =~ s/([^\w])/"%".sprintf("%02x", ord($1))/eg;
  return $string;
}

################################################################
sub URLdecode {
  my $string = $_[0];
  $string =~ tr/+/ /;
  $string =~ s/%([\da-fA-F]{2})/pack("C",hex($1))/eg;
  return $string;
}

#################################################################

sub get_long_id {
	# incoming $dir must contain a trailing /
	my ($dir, $cache_limit, $file_life_span) = @_;
	
  opendir(DIR, $dir) or &errorPage("Error Logging On (a).");
  my @files = readdir(DIR);
  closedir(DIR);
  
  if($#files >= $cache_limit) {
  	foreach $file (@files) {
    		if((-f "$dir$file") && ((-M "$dir$file") > $file_life_span)) {
    			unlink "$dir$file";  #delete the file
    		} 
 		} 
  	opendir(DIR, $dir) or &errorPage("Error Logging On (b).");
 		@files = readdir(DIR);
  	closedir(DIR);

  	if($#files >= $cache_limit) {
  		# should generate e-mail message to warn administrator (see Ssection 9.?)
  		&errorPage("Site busy. Please try again later.");
  	}
  }
	return &generate_random_string(32);
}

#################################################################
sub generate_random_string {
  my $length = $_[0];
  my $result = "";
  my @chars = (0..9, 'a'..'z', 'A'..'Z');
  my $which;
  for($i = 1 ; $i <= $length ; $i++) {
  	$which=int rand 62;
    $result = $result . $chars[$which];
  }
  return $result;
}

#################################################################
sub errorPage {
 my $message = $_[0];  # optional message parameter
 
 print<<ALL;
 <html><head><title>Server Error</title></head><body>
  <h2>Server Error Encountered</h2>
  $message 
  
  If the problem persists, please notify the <a href="mailto:admin\@uweb.edu">webmaster</a>.
 </body></html>
ALL
 
	exit;   # terminate program since failure to open data file
}
