hanoi(N):-move(N,left,centre,right).
move(0,_,_,_):-!.
move(N,S,D,T):-M is N-1, move(M,S,T,D),write('Move a disc from '), write(S), write(' to '), write(D),nl,move(M,T,D,S).

subset([],_).
subset([H|T],Y):-member(H,Y),subset(T,Y).

intersection([],_,[]).
intersection([X|R],Y,[X|Z]):-member(X,Y),!,intersection(R,Y,Z).
intersection([_|R],Y,Z):-intersection(R,Y,Z).

union([],X,X).
union([H|T],X,Y):-member(H,X),!,union(T,X,Y).
union([H|T],X,[H|Y]):-union(T,X,Y).

size([],0).
size([_|T],N):-size(T,M),N is M+1.

equals(X,Y):-length(X,N),length(Y,N),subset(X,Y).

dif([],_,[]).
dif([H|T],L,R):-member(H,L),!,dif(T,L,R).
dif([H|T],L,[H|R]):-dif(T,L,R).

delete_all(_,[],[]).
delete_all(X,[X|T],R):-!,delete_all(X,T,R).
delete_all(X,[Y|T],[Y|R]):-delete_all(X,T,R).

rd([],[]).
rd([H|T],[H|R]):-delete_all(H,T,NT),rd(NT,R).

