cd(album(title(fallen),band(evanescence)),
   category(rock),
   year(2003),
   price(used(16),new(24))).

cd(album(title(reload),band(metallica)),
   category(metal),
   year(1997),
   price(used(13),new(25))).

cd(album(title(no_need_to_argue),band(cranberries)),
   category(rock),
   year(1999),
   price(used(18),new(24))).
   
cd(album(title(demon_days),band(cranberries)),
   category(hip_hop),
   year(2005),
   price(used(16),new(24))).
   
cd(album(title(master_of_puppets),band(metallica)),
   category(metal),
   year(1990),
   price(used(17),new(24))).
   
cd(album(title(war),band(u2)),
   category(pop),
   year(1990),
   price(used(15),new(28))).   

album_category(album(T,B),Category) :- 
	cd(album(title(T),band(B)),category(Category),_,_).

album_year(album(T,B),Year) :- 
	cd(album(title(T),band(B)),_,year(Year),_).

%recent_album(A,Year) :-album_year(A,Y2),Y2>=Year.

recent_album(album(T,B),Year) :-
	cd(album(title(T),band(B)),_,year(X),_), X >= Year.

buy_only_used(album(T,B),Amount) :-
	cd(album(title(T),band(B)),_,_,price(used(X1),new(X2))), 
	X1 =< Amount, Amount =< X2.

same_used_price(album(T1,B1),album(T2,B2)) :-
	cd(album(title(T1),band(B1)),_,_,price(used(X1),_)),
	cd(album(title(T2),band(B2)),_,_,price(used(X2),_)),
	X1 = X2, T1 \= T2, B1 \= B2.






