split(_, [], [], []).
split(Number, [Head|Rest], [Head|Smaller], Larger):-
	Head < Number,
	split(Number, Rest, Smaller, Larger).
split(Number, [Head|Rest], Smaller, [Head|Larger]):-
	Head >= Number,
	split(Number, Rest, Smaller, Larger).

occurs(_, [], 0).
occurs(X, [Head|Tail], N):-
	Head =:= X,
	occurs(X, Tail, N1),
	N is N1+1.
occurs(X, [Head|Tail], N):-
	Head =\= X,
	occurs(X, Tail, N).
	
max(X, Y, X) :- X >= Y.
max(X, Y, Y) :- X < Y.

maxlist([X], X).
maxlist([X,Y|Rest], Max) :-
	maxlist([Y|Rest], MaxRest),
	max(X, MaxRest, Max).
	
sumlist([], 0).
sumlist([H|T], Sum) :-
	sumlist(T, Sum2),
	Sum is H + Sum2.
	
