first(X,[_,_,X|_]).

third(X,[_,_,X|_]).

penult(X,[X,_]).
penult(X,[_|T]):-penult(X,T).

equal_size([],[]).
equal_size([_|T1],[_|T2]):-equal_size(T1,T2).

subset([],_).
subset([H|T],L):-member(H,L),subset(T,L).

same_elements(L1,L2):-equal_size(L1,L2),subset(L1,L2).

equals([],[]). 
equals([X|T1],[X|T2]):-equals(T1,T2).
	
%  equals(X,X).

replace(_,_,[],[]).
replace(X,Y,[X|Tail],[Y|Tail2]):-replace(X,Y,Tail,Tail2).
replace(X,Y,[Z|Tail],[Z|Tail2]):-X\=Z,replace(X,Y,Tail,Tail2).
	
replace_all(_, _, [], []).
replace_all(X, Y, [Head|Tail], [Y|Result]):-
		Head =:= X,
		replace_all(X, Y, Tail, Result).
replace_all(X, Y, [Head|Tail], [Head|Result]):-
		Head =\= X,
		replace_all(X, Y, Tail, Result).
