dist(thessaloniki,katerini,80).
dist(katerini,larisa,70).
dist(larisa,volos,60).
dist(lamia,volos,90).
dist(athens,lamia,220).
dist(kastoria,veroia,100).
dist(thessaloniki,veroia,70).
dist(thessaloniki,edessa,80).
dist(edessa,kastoria,100).
dist(lamia,kastoria,100).
dist(irakleio,xania,170).
dist(irakleio,rethymno,100).

road(X,Y,D):-dist(X,Y,D).
road(X,Y,D):-dist(Y,X,D).

con(X,Y,D):-road(X,Y,D).
con(X,Y,D):-road(X,Z,D1),con(Z,Y,D2),D is D1+D2.

connected(X,Y,D):-c(X,Y,[X],D).
c(X,X,_,0).
c(X,Y,L,D):-road(X,Z,D1),not(member(Z,L)),c(Z,Y,[Z|L],D2),D is D1+D2.

path(X,Y,L,D):-c2(X,Y,[X],L,D).
c2(X,X,L,L,0).
c2(X,Y,L,L2,D):-road(X,Z,D1),not(member(Z,L)),c2(Z,Y,[Z|L],L2,D2), D is D1+D2.



cities(L):-setof(X,Y^D^road(X,Y,D),L).

can_go(X,L):-setof(Y,Y^D^connected(X,Y,D),L).

in_distance(X,D,L):-setof(Y,Y^D^close(X,Y,D),L).

close(X,Y,D):-connected(X,Y,D2),D2=<D,D2>0.

shortest_path(X,Y,L,D):-findall(p(V,P),path(X,Y,P,V),AP),sort(AP,[p(D,L)|_]).



